/** @file   particleblood.cpp
 * @brief   Implementation of particleblood - class
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "particleblood.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================

int ParticleBlood::averageLifetime = 30;



///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
ParticleBlood::ParticleBlood( const Vec2D& rP, const Vec2D& rD, int num,
                              const Color& rC )
{
  Vec2D normDir( rD );
  normDir.norm();
  float s = rD.length() / 2.0;
  
  for ( int i=0; i < num; i++ ) {
    Particle* pPart = new Particle();
    
    pPart->m_pos = rP;
    pPart->lifetime( averageLifetime + ( rand() % 10 ) );
    pPart->setColor( rC );
    pPart->m_dirVec = normDir;
    pPart->m_dirVec *= s + ( static_cast<float>( rand() % 100 ) / 100.0 );
    // We rotate the direction vector
    pPart->m_dirVec.rotate( ( rand() % 128 ) - 64 );
    pPart->m_friction = 0.8;
    
    this->addParticle( pPart );
  }
}



/** Destructor
 */
ParticleBlood::~ParticleBlood()
{
}




///
/// Public methods
/// ==============

/** Draws this particlesystem
 */
void ParticleBlood::redraw( BITMAP* aTarget, const Vec2D& aOffset )
{
  set_trans_blender(0,0,0, 40);
  drawing_mode( DRAW_MODE_TRANS, 0, 0,0 );
  ParticleSystem::redraw( aTarget, aOffset );
  solid_mode();
}

} // end of namespace
